// ################################################################################
//
//  RGB LED Test vB0
//
//  Released:  26/12/2024
//
//  Author: TechKnowTone
//
// ################################################################################
/*
    TERMS OF USE: This software is furnished "as is", without technical support, and
    with no warranty, expressed or implied, as to its usefulness for any purpose. In
    no event shall the author or copyright holder be liable for any claim, damages,
    or other liability, whether in an action of contract, tort or otherwise, arising
    from, out of or in connection with the software or the use or other dealings in
    the software.

    microcontroller: ESP32 Dev Module   v3.0.2

    This code was writtent to confirm the function of the RGB LED strips, around the
    shell of the Omni-Bot body,
    
    IMPORTANT - Espressif changed the way ESP-NOW works from v3.0, which broke the original
    code and caused compiler errors. This version has been modified to work with v3.0+.
    Enjoy!
*/
// Declare libraries
// #include <Wire.h> //Include the Wire.h library so we can communicate with the gyro
#include <FastLED.h>            // Neopixel library           v3.7.3

#define Released "26/12/2024"

// Define constants
// We define 15 LEDs in the strip, but this can drive sections of 5 LEDs, and 3
// sections of 5.
#define LED_Pin  5                  // GPIO for RGB LEDs
#define NumLEDs 15                  // total number of neopixel LEDs
 
// create a FastLED instance and define the total number of LEDs on the robot
CRGB LED[NumLEDs];        // LEDs connected to micro for o/p
CRGB LEDX[1];             // temp LED value

// Declare and initialise general global variables
uint8_t Blu = 0;          // LED blue colour
uint8_t Bright=64;        // FastLED brightness
uint8_t Grn = 0;          // LED green colour
uint8_t Red = 0;          // LED red colour

// --------------------------------------------------------------------------------

void setup() {
  // Setup basic functions
  Serial.begin(115200); // use this default baud rate for Nunchuk wireless control

  // initialise the FastLED component
  // a chain of 12 LEDs = 24 x 12 = 288 bits, taking 360us to show at 800kbps
  FastLED.addLeds<WS2812B, LED_Pin, GRB>(LED, NumLEDs);
  FastLED.setBrightness(Bright);
  FastLED.clear();
  FastLED.show();

  Serial.println("RGB LED Test");
  Serial.println(Released);
}

// --------------------------------------------------------------------------------

void loop() {
  // This main loop runs continuously, on a ~4 second cycle
  // Set LEDs red
  Red = Bright; Grn = 0; Blu = 0;
  for (int zL = 0;zL < 15;zL++) {LED[zL].setRGB(Red,Grn,Blu);}
  FastLED.show();
  Serial.println("Red");
  delay(1000);

  // Set LEDs green
  Red = 0; Grn = Bright; Blu = 0;
  for (int zL = 0;zL < 15;zL++) {LED[zL].setRGB(Red,Grn,Blu);}
  FastLED.show();
  Serial.println("Green");
  delay(1000);

  // Set LEDs blue
  Red = 0; Grn = 0; Blu = Bright;
  for (int zL = 0;zL < 15;zL++) {LED[zL].setRGB(Red,Grn,Blu);}
  FastLED.show();
  Serial.println("Blue");
  delay(1000);

  // Reandom
  Serial.println("Random");
  for (int zL = 0;zL < 10;zL++) {
    Red = random(Bright); Grn = random(Bright); Blu = random(Bright);
    for (int zL = 0;zL < 15;zL++) {LED[zL].setRGB(Red,Grn,Blu);}
    FastLED.show();
    delay(100);
  }
}

// --------------------------------------------------------------------------------
